/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.Kick;
import Information.BaseSeeInformation;
import Information.PlayerInformation;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;

abstract class KickAnalyzer
extends Analyzer {
    BaseSeeInformation bsi;
    Vector kickVector;
    boolean kickChanged = false;
    boolean catchBall = false;
    double ball_vx;
    double ball_vy;
    public static boolean VERBOSE = false;

    public KickAnalyzer(BaseSeeInformation bsi) {
        this.bsi = bsi;
        bsi.addObserver(this);
        this.kickVector = new Vector();
    }

    abstract void analyze();

    public Vector getKickVector() {
        return this.kickVector;
    }

    public Kick getLastKick() {
        return (Kick)this.kickVector.lastElement();
    }

    public double getBallVX() {
        return this.ball_vx;
    }

    public double getBallVY() {
        return this.ball_vy;
    }

    protected void setKickMember(int step, int member, int side) {
        Kick kick = new Kick(member, side, this.bsi.time, this.bsi.team[side].player[member - 1].x, this.bsi.team[side].player[member - 1].y);
        this.kickVector.addElement(kick);
        if (VERBOSE) {
            System.out.println(String.valueOf(member) + "kick");
        }
        this.setChanged();
        this.notifyObservers(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.analyze();
    }

    public boolean doCatchBall() {
        return this.catchBall;
    }

    public int getTotalKick(int side) {
        int kick = 0;
        Enumeration enu = this.kickVector.elements();
        while (enu.hasMoreElements()) {
            Kick k = (Kick)enu.nextElement();
            if (k.getSide() != side) continue;
            ++kick;
        }
        return kick;
    }

    public int getPlayerKick(int unum, int side) {
        int kick = 0;
        Enumeration enu = this.kickVector.elements();
        while (enu.hasMoreElements()) {
            Kick k = (Kick)enu.nextElement();
            if (k.getMember() != unum || k.getSide() != side) continue;
            ++kick;
        }
        return kick;
    }

    protected double getDistanceFromPlayerToBall(PlayerInformation pi) {
        double dist = (pi.x - this.bsi.ball.x) * (pi.y - this.bsi.ball.y);
        return dist;
    }
}

