/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.Dribble;
import Analyzer.DribbleAnalyzer;
import Analyzer.DribblePoint;
import Analyzer.Pass;
import Analyzer.PassAnalyzer;
import Information.BaseSeeInformation;
import java.util.Observable;
import java.util.Vector;

public class PosPercentageAnalyzer
extends Analyzer {
    public static final boolean VERBOSE = true;
    BaseSeeInformation bsi;
    Vector passVector;
    Vector dribbleVector;
    int[] posTime = new int[2];

    public PosPercentageAnalyzer(PassAnalyzer pa, DribbleAnalyzer da) {
        pa.addObserver(this);
        da.addObserver(this);
        this.dribbleVector = da.getDribbleVector();
        this.passVector = pa.getPassVector();
        this.posTime[1] = 0;
        this.posTime[0] = 0;
    }

    public double getPosPercentage(int side) {
        if (this.posTime[0] + this.posTime[1] == 0) {
            return 0.5;
        }
        return (double)this.posTime[side] / ((double)this.posTime[0] + (double)this.posTime[1]);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof PassAnalyzer) {
            Pass p = (Pass)this.passVector.lastElement();
            int n = p.side;
            this.posTime[n] = this.posTime[n] + (p.recvTime - p.passTime);
            System.out.println("shihai side:" + p.side + "time:" + this.posTime[p.side]);
        } else if (o instanceof DribbleAnalyzer) {
            Dribble d = (Dribble)this.dribbleVector.lastElement();
            Vector v = d.getDribblePoints();
            int dsize = v.size();
            DribblePoint dp1 = (DribblePoint)v.elementAt(dsize - 2);
            DribblePoint dp2 = (DribblePoint)v.elementAt(dsize - 1);
            int n = d.side;
            this.posTime[n] = this.posTime[n] + (dp2.time - dp1.time);
            System.out.println("shihai side:" + d.side + "time:" + this.posTime[d.side]);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void analyze() {
    }
}

