/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.Kick;
import Analyzer.KickAnalyzer;
import Analyzer.Shoot;
import Information.BaseSeeInformation;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;

public class ShootAnalyzer
extends Analyzer {
    private static final int TIME = 20;
    private static final boolean VERBOSE = true;
    BaseSeeInformation bsi;
    KickAnalyzer ka;
    Vector kickVector;
    Vector shootVector;

    public ShootAnalyzer(BaseSeeInformation bsi, KickAnalyzer ka) {
        this.bsi = bsi;
        ka.addObserver(this);
        this.shootVector = new Vector();
        this.ka = ka;
        this.kickVector = ka.getKickVector();
    }

    public Vector getShootVector() {
        return this.shootVector;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof KickAnalyzer) {
            this.analyze();
        }
    }

    public void analyze() {
        double y;
        double x;
        Kick thisKick = (Kick)this.kickVector.lastElement();
        double angle = this.bsi.ball.angle;
        double vx = this.ka.getBallVX();
        double vy = this.ka.getBallVY();
        double x0 = x = this.bsi.ball.x;
        double y0 = y = this.bsi.ball.y;
        int i = 1;
        while (i <= 20) {
            x += (vx *= 0.94);
            y += (vy *= 0.94);
            ++i;
        }
        double katamuki = 0.0;
        double a = 0.0;
        if (x - x0 == 0.0) {
            System.out.println("katamuki = 0!!!");
            return;
        }
        katamuki = (y - y0) / (x - x0);
        a = katamuki * -x + y;
        if (x >= 52.5) {
            double yy = katamuki * 52.5 + a;
            System.out.println("location of across goal line (" + x + "," + yy + ")");
            if (yy <= 10.0 && yy >= -10.0 && thisKick.getSide() == 0) {
                double diffX = thisKick.posX - 52.5;
                double diffY = thisKick.posY - yy;
                double dist = Math.sqrt(diffX * diffX + diffY * diffY);
                Shoot shoot = new Shoot(thisKick.getMember(), thisKick.getSide(), this.bsi.time, thisKick.posX, thisKick.posY, dist);
                this.shootVector.addElement(shoot);
                this.setChanged();
                this.notifyObservers(shoot);
                System.out.println("ShootR");
            }
        } else if (x <= -52.5) {
            double yy = katamuki * -52.5 + a;
            System.out.println("location of across goal line (" + x + "," + yy + ")");
            if (yy <= 10.0 && yy >= -10.0 && thisKick.getSide() == 1) {
                double diffX = thisKick.posX - 52.5;
                double diffY = thisKick.posY - yy;
                double dist = Math.sqrt(diffX * diffX + diffY * diffY);
                Shoot shoot = new Shoot(thisKick.getMember(), thisKick.getSide(), this.bsi.time, thisKick.posX, thisKick.posY, dist);
                this.shootVector.addElement(shoot);
                this.setChanged();
                this.notifyObservers(shoot);
                System.out.println("SHOOT L");
            }
        }
    }

    public int getPlayerShoot(int unum, int side) {
        int shoot = 0;
        Enumeration enu = this.shootVector.elements();
        while (enu.hasMoreElements()) {
            Shoot s = (Shoot)enu.nextElement();
            if (s.getMember() != unum || s.getSide() != side) continue;
            ++shoot;
        }
        return shoot;
    }
}

