/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.GoalAnalyzer;
import Analyzer.InterceptAnalyzer;
import Analyzer.KickAnalyzer;
import Analyzer.MessageSender;
import Analyzer.OneTwoPassAnalyzer;
import Analyzer.PassAnalyzer;
import Analyzer.PlayModeAnalyzer;
import Analyzer.ShootAnalyzer;
import Information.BallInformation;
import Information.BaseHearInformation;
import Information.BaseSeeInformation;
import Information.PlayerInformation;
import Strategy.BallClearStrategy;
import Strategy.BaseStrategy;
import Strategy.CounterStrategy;
import Strategy.OneTwoReturnStrategy;
import Strategy.ThroughPassStrategy;
import Utility.Utility;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;

public class StrategyRelayEvaluater
extends Analyzer {
    Vector strategyVector;
    int currentStrategy = 0;
    BaseStrategy bs;
    public BaseHearInformation bhi;
    public BaseSeeInformation bsi;
    public KickAnalyzer ka;
    MessageSender ms;
    public static final int NO_STRAT = 0;
    public static final int STRAT_BALL_CLEAR = 1;
    public static final int STRAT_COUNTER = 2;
    public static final int STRAT_ONE_TWO_PASS = 3;
    public static final int STRAT_THROUGH_PASS = 4;

    public StrategyRelayEvaluater(BaseHearInformation bhi, BaseSeeInformation bsi, GoalAnalyzer ga, ShootAnalyzer sa, OneTwoPassAnalyzer otpa, PlayModeAnalyzer pma, InterceptAnalyzer ia, PassAnalyzer pa, KickAnalyzer ka, MessageSender ms) {
        this.bhi = bhi;
        this.bsi = bsi;
        this.ka = ka;
        this.ms = ms;
        ga.addObserver(this);
        sa.addObserver(this);
        otpa.addObserver(this);
        pma.addObserver(this);
        ia.addObserver(this);
        pa.addObserver(this);
        this.strategyVector = new Vector();
    }

    public Vector getStrategyVector() {
        return this.strategyVector;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.currentStrategy != 0 && this.bs.update(o, arg) == 0) {
            this.ms.addMessage(this.bs.getResult());
            this.currentStrategy = 0;
        }
    }

    public void analyze() {
        StringTokenizer strtk = new StringTokenizer(this.bhi.message, " ()");
        int i = 1;
        while (i <= 4) {
            strtk.nextToken();
            ++i;
        }
        int unum = new Integer(strtk.nextToken());
        while (strtk.hasMoreTokens()) {
            if (!strtk.nextToken().equals("strategy")) continue;
            String strategy = strtk.nextToken();
            strtk.nextToken();
            String type = strtk.nextToken();
            if (this.currentStrategy != 0 && (type.equals("plan") || type.equals("show"))) {
                if (this.bs.getUnum() == unum && this.bsi.time - this.bs.getTime() <= 2 || this.bsi.time - this.bs.getTime() <= 1) {
                    this.currentStrategyCancel();
                }
                PlayerInformation player = this.bsi.team[0].player[unum - 1];
                BallInformation ball = this.bsi.ball;
                double toBallDist = Utility.getDistance(player.x, player.y, ball.x, ball.y);
                if (toBallDist <= 1.885) {
                    System.out.println("fixed!!");
                    this.ka.setKickMember(this.bsi.time, unum, 0);
                }
                System.out.println("stragegy is said!");
                this.bs.evaluate(strategy);
                this.ms.addMessage(this.bs.getResult());
                this.currentStrategy = 0;
            }
            if (strategy.equals("private") || type.equals("reply")) break;
            if (strategy.equals("ballClear")) {
                this.bs = new BallClearStrategy(this.bhi.time, unum, this, strategy);
                this.currentStrategy = 1;
                this.strategyVector.addElement(this.bs);
                break;
            }
            if (strategy.equals("counter")) {
                this.bs = new CounterStrategy(this.bhi.time, unum, this, strategy);
                this.currentStrategy = 2;
                this.strategyVector.addElement(this.bs);
                break;
            }
            if (strategy.equals("1-2Return")) {
                this.bs = new OneTwoReturnStrategy(this.bhi.time, unum, this, strategy);
                this.currentStrategy = 3;
                this.strategyVector.addElement(this.bs);
                break;
            }
            if (strategy.equals("throughPass")) {
                this.bs = new ThroughPassStrategy(this.bhi.time, unum, this, strategy);
                this.currentStrategy = 4;
                this.strategyVector.addElement(this.bs);
                break;
            }
            System.out.println("not implemented");
            this.currentStrategy = 0;
            break;
        }
    }

    protected void currentStrategyCancel() {
        System.out.println("stragegy is canceled");
        this.strategyVector.removeElementAt(this.strategyVector.size() - 1);
        this.currentStrategy = 0;
    }
}

