/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.FieldBallObject;
import GUI.FieldObject;
import GUI.FieldPlayerObject;
import Information.BaseSeeInformation;
import Information.CParam;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Observable;
import java.util.Observer;

public class FieldCanvas
extends Canvas
implements Observer {
    Image buff = null;
    Image backField = null;
    Graphics gbuff;
    Graphics gbf;
    int width = FieldCanvas.InPitchSize(115.0) + 1;
    int height = FieldCanvas.InPitchSize(78.0) + 1;
    static int length_magnify = 3;
    FieldObject fo1;
    FieldObject fo2;

    public FieldCanvas(BaseSeeInformation bsi) {
        this(length_magnify, bsi);
    }

    public FieldCanvas(int length_magnify, BaseSeeInformation bsi) {
        this.setSize(this.width, this.height);
        this.fo1 = new FieldPlayerObject(this, bsi);
        this.fo2 = new FieldBallObject(this, bsi);
        bsi.addObserver(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.buff == null) {
            this.buff = this.createImage(this.width, this.height);
            this.gbuff = this.buff.getGraphics();
        }
        if (this.backField == null) {
            this.backField = this.createImage(this.width, this.height);
            this.gbf = this.backField.getGraphics();
            this.drawField(this.gbf);
            this.gbuff.drawImage(this.backField, 0, 0, this);
        }
        g.drawImage(this.buff, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void update(Observable o, Object arg) {
        BaseSeeInformation bsi = (BaseSeeInformation)o;
        try {
            if (this.gbuff == null || this.backField == null) {
                Thread.sleep(100L);
                this.repaint();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.gbuff.drawImage(this.backField, 0, 0, this);
        this.fo1.draw();
        this.fo2.draw();
        this.repaint();
    }

    public void drawBackField() {
        this.gbuff.drawImage(this.backField, 0, 0, this);
    }

    public void clearGraphicsBuffer() {
        this.buff = null;
        this.backField = null;
    }

    public Graphics getGraphicsBuffer() {
        return this.gbuff;
    }

    public void createGraphicsBuffer() {
        this.buff = this.createImage(this.width, this.height);
        this.gbuff = this.buff.getGraphics();
        this.backField = this.createImage(this.width, this.height);
        this.gbf = this.backField.getGraphics();
        this.drawField(this.gbf);
        this.gbuff.drawImage(this.backField, 0, 0, this);
    }

    private void drawField(Graphics grf) {
        double gwidth = 14.02;
        int degree = (int)CParam.RAD2DEG(Math.acos(0.6010928961748634));
        this.gbf.setColor(Color.orange.darker());
        this.gbf.fillRect(0, 0, FieldCanvas.InPitchSize(115.0) + 1, FieldCanvas.InPitchSize(78.0) + 1);
        this.gbf.setColor(Color.green.darker().darker());
        this.gbf.fillRect(FieldCanvas.InFieldPosX(-52.5), FieldCanvas.InFieldPosY(-34.0), FieldCanvas.InPitchSize(105.0), FieldCanvas.InPitchSize(68.0));
        this.gbf.setColor(Color.white);
        this.gbf.drawRect(FieldCanvas.InFieldPosX(-52.5), FieldCanvas.InFieldPosY(-34.0), FieldCanvas.InPitchSize(105.0), FieldCanvas.InPitchSize(68.0));
        this.gbf.drawLine(FieldCanvas.InFieldPosX(0.0), FieldCanvas.InFieldPosY(-34.0), FieldCanvas.InFieldPosX(0.0), FieldCanvas.InFieldPosY(34.0));
        this.gbf.drawRect(FieldCanvas.InFieldPosX(-52.5), FieldCanvas.InFieldPosY(-20.16), FieldCanvas.InPitchSize(16.5), FieldCanvas.InPitchSize(40.32));
        this.gbf.drawRect(FieldCanvas.InFieldPosX(36.0), FieldCanvas.InFieldPosY(-20.16), FieldCanvas.InPitchSize(16.5), FieldCanvas.InPitchSize(40.32));
        this.gbf.drawRect(FieldCanvas.InFieldPosX(-52.5), FieldCanvas.InFieldPosY(-9.16), FieldCanvas.InPitchSize(5.5), FieldCanvas.InPitchSize(18.32));
        this.gbf.drawRect(FieldCanvas.InFieldPosX(47.0), FieldCanvas.InFieldPosY(-9.16), FieldCanvas.InPitchSize(5.5), FieldCanvas.InPitchSize(18.32));
        this.gbf.drawOval(FieldCanvas.InFieldPosX(-9.15), FieldCanvas.InFieldPosY(-9.15), FieldCanvas.InPitchSize(18.3), FieldCanvas.InPitchSize(18.3));
        this.gbf.drawArc(FieldCanvas.InFieldPosX(-50.65) + 2, FieldCanvas.InFieldPosY(-9.15), FieldCanvas.InPitchSize(18.3), FieldCanvas.InPitchSize(18.3), -degree, degree * 2);
        this.gbf.drawArc(FieldCanvas.InFieldPosX(32.35) + 1, FieldCanvas.InFieldPosY(-9.15), FieldCanvas.InPitchSize(18.3), FieldCanvas.InPitchSize(18.3), 180 - degree, degree * 2);
        this.gbf.drawArc(FieldCanvas.InFieldPosX(-53.5), FieldCanvas.InFieldPosY(-35.0), FieldCanvas.InPitchSize(2.0), FieldCanvas.InPitchSize(2.0), -90, 90);
        this.gbf.drawArc(FieldCanvas.InFieldPosX(51.5), FieldCanvas.InFieldPosY(-35.0), FieldCanvas.InPitchSize(2.0), FieldCanvas.InPitchSize(2.0), 180, 90);
        this.gbf.drawArc(FieldCanvas.InFieldPosX(-53.5), FieldCanvas.InFieldPosY(33.0), FieldCanvas.InPitchSize(2.0), FieldCanvas.InPitchSize(2.0), 0, 90);
        this.gbf.drawArc(FieldCanvas.InFieldPosX(51.5), FieldCanvas.InFieldPosY(33.0), FieldCanvas.InPitchSize(2.0), FieldCanvas.InPitchSize(2.0), 90, 90);
        this.gbf.setColor(Color.black);
        this.gbf.fillRect(FieldCanvas.InFieldPosX(-54.94) + 1, FieldCanvas.InFieldPosY(-gwidth / 2.0), FieldCanvas.InPitchSize(2.44) + 1, FieldCanvas.InPitchSize(gwidth) + 1);
        this.gbf.fillRect(FieldCanvas.InFieldPosX(52.5), FieldCanvas.InFieldPosY(-gwidth / 2.0), FieldCanvas.InPitchSize(2.44) + 1, FieldCanvas.InPitchSize(gwidth) + 1);
    }

    public static final int InPitchSize(double l) {
        return (int)(l * (double)length_magnify);
    }

    public static final int InPitchPosX(double x) {
        return FieldCanvas.InPitchSize(x + 52.5);
    }

    public static final int InPitchPosY(double y) {
        return FieldCanvas.InPitchSize(y + 34.0);
    }

    public static final int InFieldPosX(double x) {
        return FieldCanvas.InPitchPosX(x + 5.0);
    }

    public static final int InFieldPosY(double y) {
        return FieldCanvas.InPitchPosY(y + 5.0);
    }

    public static final int InPitchPosX(short x) {
        return FieldCanvas.InPitchPosX((double)x);
    }

    public static final int InPitchPosY(short y) {
        return FieldCanvas.InPitchPosY((double)y);
    }

    public static final int InFieldPosX(short x) {
        return FieldCanvas.InFieldPosX((double)x);
    }

    public static final int InFieldPosY(short y) {
        return FieldCanvas.InFieldPosY((double)y);
    }

    public static final int InDisplaySize(double l) {
        return FieldCanvas.InPitchSize(l * 2.0);
    }

    public static void main(String[] arg) {
        Frame f = new Frame();
        Canvas c = new Canvas();
        f.add(c);
        c.setVisible(true);
    }
}

