/*
 * Decompiled with CFR 0.152.
 */
package info_managerP;

import genericP.Generic;
import genericP.Point;
import info_managerP.PlayerTable;
import objectP.PlayerInfo;
import objectP.StrategyInfo;

public class StrategyTable {
    StrategyInfo[] strategyWithUNum = new StrategyInfo[11];
    StrategyInfo[] strategyNonUNum = new StrategyInfo[11];
    PlayerTable playerTable;
    int teammateCount;

    public StrategyTable(PlayerTable pTable) {
        this.formatAll();
        this.teammateCount = 0;
        this.playerTable = pTable;
    }

    public void printInfo() {
        int i = 0;
        while (i < 11) {
            if (this.strategyWithUNum[i].getCertainty() > 0.1) {
                System.out.println("UniformNun : " + (i + 1));
                System.out.println("Strategy : " + this.strategyWithUNum[i].getStrategy());
                System.out.println("Type : " + this.strategyWithUNum[i].getType());
                System.out.println("(X,Y) = (" + this.strategyWithUNum[i].getX() + "," + this.strategyWithUNum[i].getY() + ")");
                System.out.println("Certainty : " + this.strategyWithUNum[i].getCertainty());
            }
            ++i;
        }
        i = 0;
        while (i < this.teammateCount) {
            if (this.strategyNonUNum[i].getCertainty() > 0.1) {
                System.out.println("UniformNun : Unknown");
                System.out.println("Strategy : " + this.strategyNonUNum[i].getStrategy());
                System.out.println("Type : " + this.strategyWithUNum[i].getType());
                System.out.println("(X,Y) = (" + this.strategyNonUNum[i].getX() + "," + this.strategyNonUNum[i].getY() + ")");
                System.out.println("Certainty : " + this.strategyNonUNum[i].getCertainty());
            }
            ++i;
        }
    }

    public void formatAll() {
        int i = 0;
        while (i < 11) {
            this.strategyWithUNum[i] = new StrategyInfo();
            this.strategyNonUNum[i] = new StrategyInfo();
            ++i;
        }
    }

    public void refresh() {
        int i = 0;
        while (i < 11) {
            this.strategyWithUNum[i].setStrategy("unknown", "norm");
            this.strategyWithUNum[i].setCertainty(0.0);
            this.strategyNonUNum[i].setStrategy("unknown", "norm");
            this.strategyNonUNum[i].setCertainty(0.0);
            ++i;
        }
    }

    public boolean hasPlayerSInfo(int unum) {
        return this.strategyWithUNum[unum - 1].getCertainty() > 0.1;
    }

    public void updateStrategyTable() {
        int i = 0;
        while (i < 11) {
            this.strategyWithUNum[i].calcNextState();
            ++i;
        }
    }

    public void setPlayerStrategy(int unum, String S, String tp) {
        this.strategyWithUNum[unum - 1].setStrategy(S, tp);
    }

    public void setPlayerSPos(int unum, double X, double Y) {
        this.strategyWithUNum[unum - 1].setPos(X, Y);
    }

    public String getPlayerStrategy(int unum) {
        return this.strategyWithUNum[unum - 1].getStrategy();
    }

    public double getReceivePartner(String S, String tp, double dir, double dirDiff, double dist, double X, double Y, Point recXY) {
        double minValue = 1000.0;
        int i = 0;
        while (i < 11) {
            PlayerInfo partner;
            if (this.strategyWithUNum[i].getStrategy().equals(S) && this.strategyWithUNum[i].getType().equals(tp) && (partner = this.playerTable.getTeammateInfo(i + 1)).getCertainty() > 0.1) {
                double value;
                double tx = partner.getX();
                double ty = partner.getY();
                double tdir = 57.29577951308232 * Math.atan2(ty - Y, tx - X);
                double tdist = Generic.DIST(X, Y, tx, ty);
                if (tdist <= dist && Math.abs(Generic.normDir(tdir - dir)) <= dirDiff && (value = this.playerTable.evalLine(X, Y, tx, ty)) < minValue) {
                    recXY.setPointX(tx);
                    recXY.setPointY(ty);
                    minValue = value;
                }
            }
            ++i;
        }
        return minValue;
    }

    public int getStrategyPlanner(String S) {
        int uNum = 0;
        double C = 0.0;
        int i = 0;
        while (i < 11) {
            double tmpC;
            if (this.strategyWithUNum[i].getStrategy().equals(S) && this.strategyWithUNum[i].getType().equals("plan") && (tmpC = this.strategyWithUNum[i].getCertainty()) > C) {
                C = tmpC;
                uNum = i + 1;
            }
            ++i;
        }
        return uNum;
    }

    public int getStrategyPartner(String S) {
        int uNum = 0;
        double C = 0.0;
        int i = 0;
        while (i < 11) {
            double tmpC;
            if (this.strategyWithUNum[i].getStrategy().equals(S) && (tmpC = this.strategyWithUNum[i].getCertainty()) > C) {
                C = tmpC;
                uNum = i + 1;
            }
            ++i;
        }
        return uNum;
    }
}

