/*
 * Decompiled with CFR 0.152.
 */
package objectP;

public class StrategyInfo {
    final double conf_decay = 0.05;
    final double min_conf = 0.1;
    int controlTime;
    String strategy;
    String type;
    int uniformNum;
    double certainty;
    public static final double S_less = 0.05;
    double x;
    double y;

    public StrategyInfo() {
        this.strategy = "unknown";
        this.type = "norm";
        this.uniformNum = 0;
        this.certainty = 0.0;
    }

    public StrategyInfo(int uNum, String S_name, String tp) {
        this.strategy = S_name;
        this.uniformNum = uNum;
        this.type = tp;
        this.certainty = 1.0;
    }

    public void setStrategy(int Time, String S_name, String tp) {
        this.controlTime = Time;
        this.strategy = S_name;
        this.type = tp;
        this.certainty = 1.0;
    }

    public void setStrategy(String S_name, String tp) {
        this.strategy = S_name;
        this.type = tp;
        this.certainty = 1.0;
    }

    public void setStrategyName(String S_name) {
        this.strategy = S_name;
    }

    public void setStrategyType(String Stp) {
        this.type = Stp;
    }

    public void setUniformNum(int uNum) {
        this.uniformNum = uNum;
    }

    public void setCertainty(double c) {
        this.certainty = c;
        if (this.certainty < 0.0) {
            this.certainty = 0.0;
        }
    }

    public void advanceStrategyInfo(int filedTime) {
        if (filedTime == this.controlTime) {
            return;
        }
        this.calcNextState();
        while (filedTime - this.controlTime != 0) {
            this.calcNextState();
        }
    }

    public void calcNextState() {
        this.certainty -= 0.05;
        ++this.controlTime;
        if (this.certainty < 0.0) {
            this.certainty = 0.0;
            this.strategy = "unknown";
            this.type = "norm";
        }
    }

    public void refresh(int t) {
        this.controlTime = t;
        this.strategy = "unknown";
        this.type = "norm";
        this.certainty = 0.0;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public int getUniformNum() {
        return this.uniformNum;
    }

    public String getType() {
        return this.type;
    }

    public double getCertainty1() {
        return this.certainty;
    }

    public boolean getCertainty2() {
        return !(this.certainty < 0.1);
    }

    public int getControlTime() {
        return this.controlTime;
    }

    public String toStringStrategyInfo() {
        StringBuffer strBuff = new StringBuffer("(strategy ");
        strBuff.append(this.strategy).append(" ").append(this.uniformNum).append(" ").append(this.type).append(")");
        return strBuff.toString();
    }

    public void setPos(double X, double Y) {
        this.x = X;
        this.y = Y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getCertainty() {
        return this.certainty;
    }
}

