/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai;

import soccorob.SoccoRob;
import soccorob.ai.Team;
import soccorob.ai.wm.WorldModel;

public class Interpreter {
    private Interpreter() {
    }

    public static String setAgentSpec(int nr, String specName) {
        SoccoRob.getAgent(nr).setSpec(specName);
        return "ok";
    }

    public static String setAgentPlanner(int nr, String value) {
        SoccoRob.getAgent(nr).setPlanner(value);
        return "ok";
    }

    public static String setAllAgentSpec(String specName) {
        int i = 1;
        while (i <= WorldModel.players) {
            SoccoRob.getAgent(i).setSpec(specName);
            ++i;
        }
        return "ok";
    }

    public static String setAllVar(String varName, float value) {
        int i = 1;
        while (i <= WorldModel.players) {
            SoccoRob.getAgent((int)i).spec.setValue(varName, value);
            ++i;
        }
        return "ok";
    }

    public static String setVar(int nr, String varName, float value) {
        SoccoRob.getAgent((int)nr).spec.setValue(varName, value);
        return "ok";
    }

    public static String setAllAgentPlanner(String value) {
        int i = 1;
        while (i <= WorldModel.players) {
            SoccoRob.getAgent(i).setPlanner(value);
            ++i;
        }
        return "ok";
    }

    public static String startGame() {
        WorldModel.setGameStatus(true);
        return "ok";
    }

    public static String stopGame() {
        WorldModel.setGameStatus(false);
        return "ok";
    }

    public static String gameStatus() {
        if (WorldModel.isGameRunning()) {
            return "Game is running.";
        }
        return "Game is stopped.";
    }

    public static String printAgent(int nr) {
        if (nr > 0 && nr <= WorldModel.players) {
            return SoccoRob.getAgent(nr).toString();
        }
        return "Invalid agent number";
    }

    public static String printBall() {
        return WorldModel.getBall().toString();
    }

    public static String printOpponent(int nr) {
        if (nr > 0 && nr <= WorldModel.players) {
            return WorldModel.getPlayerObject(Team.THEM, nr).toString();
        }
        return "Invalid opponent number";
    }

    public static String reloadAgent(int nr) {
        return "Not implemented yet.";
    }

    public static String behaveAll(String name, String className) {
        int i = 1;
        while (i <= WorldModel.players) {
            SoccoRob.getAgent(i).getReactor().setBehaviorBinding(name, className);
            ++i;
        }
        return "ok";
    }

    public static String behave(int who, String name, String className) {
        SoccoRob.getAgent(who).getReactor().setBehaviorBinding(name, className);
        return "ok";
    }

    public static String behaveFileAll(String filename) {
        int i = 1;
        while (i <= WorldModel.players) {
            SoccoRob.getAgent(i).getReactor().loadBehaviorsFromFile(filename);
            ++i;
        }
        return "ok";
    }

    public static String behaveFile(int who, String filename) {
        SoccoRob.getAgent(who).getReactor().loadBehaviorsFromFile(filename);
        return "ok";
    }

    public static String getAgentVar(int who, String var) {
        if (SoccoRob.getAgent((int)who).spec.hasValueFor(var)) {
            return Float.toString(SoccoRob.getAgent((int)who).spec.getValue(var));
        }
        return "Unbound parameter.";
    }
}

