/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent;

import java.util.Hashtable;
import soccorob.ai.Debug;
import soccorob.ai.agent.Behavior;

public class BehaviorClass {
    private static Hashtable loadedBehaviors = new Hashtable();
    private static Class Behavior = BehaviorClass.loadTheBehaviorClass();
    private static BehaviorClass nullBehavior = BehaviorClass.load("soccorob.ai.agent.behaviors.NullBehavior");
    String className;
    Class planClass;
    Behavior unusedPool = null;
    Behavior allObjects = null;

    static {
        loadedBehaviors.put("soccorob.ai.agent.behaviors.NullBehavior", nullBehavior);
    }

    public String getClassName() {
        return this.className;
    }

    public static BehaviorClass load(String className) {
        Class<?> planClass;
        if (loadedBehaviors.containsKey(className)) {
            return (BehaviorClass)loadedBehaviors.get(className);
        }
        try {
            planClass = Class.forName(className);
            if (!Behavior.isAssignableFrom(planClass)) {
                Debug.Error("Class " + className + " does not implement Behavior");
                return nullBehavior;
            }
        }
        catch (ClassNotFoundException ex) {
            Debug.Error("Could not load class " + className + " ; " + ex.toString());
            return nullBehavior;
        }
        catch (SecurityException ex) {
            Debug.Error("Access denied to class " + className);
            return nullBehavior;
        }
        BehaviorClass newbeh = new BehaviorClass(className, planClass);
        loadedBehaviors.put(className, newbeh);
        return newbeh;
    }

    private BehaviorClass(String className, Class planClass) {
        this.className = className;
        this.planClass = planClass;
    }

    public void deallocate(Behavior plan) {
        plan.prevInStack = this.unusedPool;
        this.unusedPool = plan;
    }

    public Behavior New() {
        Behavior newplan;
        if (this.unusedPool == null) {
            newplan = this.instantiate();
        } else {
            newplan = this.unusedPool;
            this.unusedPool = newplan.prevInStack;
            newplan.prevInStack = null;
        }
        newplan.init();
        newplan.usedAgain();
        return newplan;
    }

    public Behavior New(Object arg1) {
        Behavior newplan;
        if (this.unusedPool == null) {
            newplan = this.instantiate();
        } else {
            newplan = this.unusedPool;
            this.unusedPool = newplan.prevInStack;
            newplan.prevInStack = null;
        }
        newplan.init(arg1);
        newplan.usedAgain();
        return newplan;
    }

    public Behavior New(Object arg1, Object arg2) {
        Behavior newplan;
        if (this.unusedPool == null) {
            newplan = this.instantiate();
        } else {
            newplan = this.unusedPool;
            this.unusedPool = newplan.prevInStack;
            newplan.prevInStack = null;
        }
        newplan.init(arg1, arg2);
        newplan.usedAgain();
        return newplan;
    }

    public Behavior New(Object arg1, Object arg2, Object arg3) {
        Behavior newplan;
        if (this.unusedPool == null) {
            newplan = this.instantiate();
        } else {
            newplan = this.unusedPool;
            this.unusedPool = newplan.prevInStack;
            newplan.prevInStack = null;
        }
        newplan.init(arg1, arg2, arg3);
        newplan.usedAgain();
        return newplan;
    }

    public Behavior New(Object arg1, Object arg2, Object arg3, Object arg4) {
        Behavior newplan;
        if (this.unusedPool == null) {
            newplan = this.instantiate();
        } else {
            newplan = this.unusedPool;
            this.unusedPool = newplan.prevInStack;
            newplan.prevInStack = null;
        }
        newplan.init(arg1, arg2, arg3, arg4);
        newplan.usedAgain();
        return newplan;
    }

    private Behavior instantiate() {
        Behavior newplan;
        try {
            newplan = (Behavior)this.planClass.newInstance();
        }
        catch (InstantiationException ex) {
            Debug.Error("InstantiationException for behavior (could be abstract)");
            return nullBehavior.New();
        }
        catch (IllegalAccessException ex) {
            Debug.Error("IllegalAccessException instantiating behavior");
            return nullBehavior.New();
        }
        newplan.classHandler = this;
        newplan.prevObject = this.allObjects;
        this.allObjects = newplan;
        return newplan;
    }

    private static Class loadTheBehaviorClass() {
        try {
            return Class.forName("soccorob.ai.agent.Behavior");
        }
        catch (ClassNotFoundException ex) {
            Debug.Panic("Could not load the Behavior class!");
        }
        catch (SecurityException ex) {
            Debug.Panic("Access denied to the Behavior class!");
        }
        return null;
    }
}

