/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import soccorob.ai.Debug;
import soccorob.ai.agent.Agent;
import soccorob.ai.agent.Behavior;
import soccorob.ai.agent.BehaviorClass;
import soccorob.ai.wm.WorldModel;
import soccorob.rt.AsyncEventHandler;
import soccorob.rt.RLThread;
import soccorob.rt.RunnableBlock;

public class Reactor
extends RLThread {
    HashMap behaviors = new HashMap();
    private static BehaviorClass nullBehavior = BehaviorClass.load("soccorob.ai.agent.behaviors.NullBehavior");
    private static BehaviorClass abstractBehavior = BehaviorClass.load("soccorob.ai.agent.behaviors.AbstractBehavior");
    private Agent agent;
    private static final int PLANINTERVAL = 1;
    private int counter = 0;
    private DeadlineMissHandler deadlineMissHandler = new DeadlineMissHandler();

    public Reactor(Agent agent) {
        this.agent = agent;
        this.runnableBlocks = new RunnableBlock[1];
        this.runnableBlocks[0] = new Part1();
    }

    public void react() {
        if (WorldModel.isGameRunning()) {
            if (this.counter++ % 1 == 0 && this.agent.updatePlanOn) {
                this.agent.getPlanner().getPlanner().updatePlan();
            }
            if (this.agent.getPlan().exec() && this.agent.updatePlanOn) {
                this.agent.getPlanner().getPlanner().updatePlan();
            }
        } else {
            this.exec("stop");
        }
    }

    BehaviorClass lookupBeh(String cmd) {
        return (BehaviorClass)this.behaviors.get(cmd);
    }

    public boolean hasBehaviorBinding(String cmd) {
        return this.lookupBeh(cmd) != null;
    }

    public Behavior createPlan(String cmd) {
        BehaviorClass behClass = this.lookupBeh(cmd);
        Behavior beh = behClass == null ? abstractBehavior.New(cmd, null) : behClass.New();
        beh.setAgent(this.agent);
        return beh;
    }

    public Behavior createPlan(String cmd, Object arg1) {
        BehaviorClass behClass = this.lookupBeh(cmd);
        Behavior beh = behClass == null ? abstractBehavior.New(cmd, new Object[]{arg1}) : behClass.New(arg1);
        beh.setAgent(this.agent);
        return beh;
    }

    public Behavior createPlan(String cmd, Object arg1, Object arg2) {
        BehaviorClass behClass = this.lookupBeh(cmd);
        Behavior beh = behClass == null ? abstractBehavior.New(cmd, new Object[]{arg1, arg2}) : behClass.New(arg1, arg2);
        beh.setAgent(this.agent);
        return beh;
    }

    public Behavior createPlan(String cmd, Object arg1, Object arg2, Object arg3) {
        BehaviorClass behClass = this.lookupBeh(cmd);
        Behavior beh = behClass == null ? abstractBehavior.New(cmd, new Object[]{arg1, arg2, arg3}) : behClass.New(arg1, arg2, arg3);
        beh.setAgent(this.agent);
        return beh;
    }

    public Behavior createPlan(String cmd, Object arg1, Object arg2, Object arg3, Object arg4) {
        BehaviorClass behClass = this.lookupBeh(cmd);
        Behavior beh = behClass == null ? abstractBehavior.New(cmd, new Object[]{arg1, arg2, arg3, arg4}) : behClass.New(arg1, arg2, arg3, arg4);
        beh.setAgent(this.agent);
        return beh;
    }

    public boolean exec(String cmd) {
        Behavior plan = this.createPlan(cmd);
        plan.setAgent(this.agent);
        boolean result = plan.exec();
        plan.free();
        return result;
    }

    public boolean exec(String cmd, Object arg1) {
        Behavior plan = this.createPlan(cmd, arg1);
        plan.setAgent(this.agent);
        boolean result = plan.exec();
        plan.free();
        return result;
    }

    public boolean exec(String cmd, Object arg1, Object arg2) {
        Behavior plan = this.createPlan(cmd, arg1, arg2);
        plan.setAgent(this.agent);
        boolean result = plan.exec();
        plan.free();
        return result;
    }

    public boolean exec(String cmd, Object arg1, Object arg2, Object arg3) {
        Behavior plan = this.createPlan(cmd, arg1, arg2, arg3);
        plan.setAgent(this.agent);
        boolean result = plan.exec();
        plan.free();
        return result;
    }

    public boolean exec(String cmd, Object arg1, Object arg2, Object arg3, Object arg4) {
        Behavior plan = this.createPlan(cmd, arg1, arg2, arg3, arg4);
        plan.setAgent(this.agent);
        boolean result = plan.exec();
        plan.free();
        return result;
    }

    public void setBehaviorBinding(String cmd, BehaviorClass behavior) {
        this.behaviors.put(cmd, behavior);
    }

    public void setBehaviorBinding(String cmd, String behaviorName) {
        this.behaviors.put(cmd, BehaviorClass.load(behaviorName));
    }

    public void loadBehaviorsFromFile(String filename) {
        StreamTokenizer st;
        try {
            FileInputStream fileStream = new FileInputStream(filename);
            BufferedReader r = new BufferedReader(new InputStreamReader(fileStream));
            st = new StreamTokenizer(r);
            st.commentChar(35);
            st.eolIsSignificant(true);
            st.lowerCaseMode(false);
            st.wordChars(65, 122);
        }
        catch (FileNotFoundException ex) {
            Debug.Error("Reactor FileNotFoundException: " + filename);
            return;
        }
        catch (SecurityException ex) {
            Debug.Error("Reactor SecurityException: " + filename);
            return;
        }
        try {
            int val = st.nextToken();
            while (true) {
                if (st.ttype == 10) {
                    val = st.nextToken();
                    continue;
                }
                if (st.ttype == -1) {
                    return;
                }
                if (st.ttype != -3) {
                    Debug.Error("Reactor: expected behavior name");
                    return;
                }
                String word = st.sval;
                val = st.nextToken();
                if (st.ttype != -3) {
                    Debug.Error("Reactor: expected name of plan class");
                    return;
                }
                this.setBehaviorBinding(word, st.sval);
                val = st.nextToken();
            }
        }
        catch (IOException ex) {
            Debug.Error("Reactor IOException");
            return;
        }
    }

    @Override
    public AsyncEventHandler getDeadlineMissHandler() {
        return this.deadlineMissHandler;
    }

    class DeadlineMissHandler
    extends AsyncEventHandler {
        DeadlineMissHandler() {
        }

        @Override
        public void handleAsyncEvent() {
            Reactor.this.waitForNextPeriod();
        }
    }

    class Part1
    implements RunnableBlock {
        Part1() {
        }

        @Override
        public void run() {
            Reactor.this.react();
            Reactor.this.waitForNextPeriod();
        }
    }
}

