/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import soccorob.ai.Debug;

public class RobotSpec {
    private HashMap values;

    public RobotSpec() {
        this.values = new HashMap();
    }

    public RobotSpec(String filename) {
        try {
            FileInputStream fileStream = new FileInputStream(filename);
            BufferedReader r = new BufferedReader(new InputStreamReader(fileStream));
            StreamTokenizer st = new StreamTokenizer(r);
            st.commentChar(35);
            st.eolIsSignificant(true);
            st.lowerCaseMode(false);
            st.parseNumbers();
            st.wordChars(65, 122);
            this.values = new HashMap();
            this.readTokenized(st);
        }
        catch (FileNotFoundException ex) {
            Debug.Error("RobotSpec FileNotFoundException: " + filename);
        }
        catch (SecurityException ex) {
            Debug.Error("RobotSpec SecurityException: " + filename);
        }
    }

    private void readTokenized(StreamTokenizer st) {
        try {
            int val = st.nextToken();
            while (true) {
                if (st.ttype == 10) {
                    val = st.nextToken();
                    continue;
                }
                if (st.ttype == -1) {
                    return;
                }
                if (st.ttype != -3) {
                    Debug.Error("RobotSpec: expected word");
                    return;
                }
                String word = st.sval;
                val = st.nextToken();
                if (st.ttype != -2) {
                    Debug.Error("RobotSpec: expected number");
                    return;
                }
                this.setValue(word, (float)st.nval);
                val = st.nextToken();
            }
        }
        catch (IOException ex) {
            Debug.Error("RobotSpec IOException");
            return;
        }
    }

    public void setValue(String id, float val) {
        this.values.put(id, new Float(val));
    }

    public boolean hasValueFor(String param) {
        return this.values.containsKey(param);
    }

    public float getValue(String param) {
        if (!this.values.containsKey(param)) {
            Debug.Note("RobotSpec doesn't have value for " + param);
            return 0.0f;
        }
        return ((Float)this.values.get(param)).floatValue();
    }
}

