/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent.behaviors;

import soccorob.ai.Point;
import soccorob.ai.Team;
import soccorob.ai.Vector;
import soccorob.ai.agent.Behavior;
import soccorob.ai.wm.WorldModel;

public class GotoPosCA
extends Behavior {
    private Vector field = new Vector();
    private Point abspos = new Point();
    private Vector tempvector = new Vector();
    private boolean addBallField;
    private static long ROBOT_R = 50L;
    private static long BALL_R = 10L;

    @Override
    public void init(Object arg1) {
        this.abspos.set((Point)arg1);
        this.addBallField = true;
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.abspos.set((Point)arg1);
        this.addBallField = false;
    }

    @Override
    public boolean exec() {
        this.field.setLength(0L);
        this.field.add(new Vector((long)this.getValue("goalattraction"), this.body().getPos().angleTo(this.abspos)));
        int i = 1;
        while (i <= WorldModel.players) {
            if (this.agent.no != i) {
                this.calcAvoidance(WorldModel.getPlayerObject(Team.WE, i).getPos(), this.tempvector, true);
                this.field.add(this.tempvector);
            }
            this.calcAvoidance(WorldModel.getPlayerObject(Team.THEM, i).getPos(), this.tempvector, true);
            this.field.add(this.tempvector);
            ++i;
        }
        if (this.addBallField) {
            this.calcAvoidance(WorldModel.getBall().getPos(), this.tempvector, false);
            this.field.add(this.tempvector);
        }
        this.field.scale(100.0f);
        return this.agent.getReactor().exec("gotoPos", this.body().getPos().pointAt(this.field), this.abspos);
    }

    private void calcAvoidance(Point pos, Vector result, boolean robot) {
        long S = (long)this.getValue("influencesphere");
        long G = (long)this.getValue("avoidancegain");
        long S2 = (long)this.getValue("tooClosesphere");
        long d = this.body().getPos().distanceTo(pos);
        long d2 = robot ? 2L * ROBOT_R : ROBOT_R + BALL_R;
        if (d > S) {
            result.setLength(0L);
        } else if (d > d2 + S2 && d <= S) {
            if (!robot) {
                result.set((S - d) / (S - (d2 + S2)) * G * 5L, 180 + this.body().getPos().angleTo(pos));
            } else {
                result.set((S - d) / (S - (d2 + S2)) * G, 180 + this.body().getPos().angleTo(pos));
            }
        } else {
            result.set((long)this.getValue("toocloserepellation"), 180 + this.body().getPos().angleTo(pos));
        }
    }

    @Override
    public String toString() {
        return "gotoPosCA";
    }
}

