/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.wm;

import soccorob.ai.Debug;
import soccorob.ai.Point;
import soccorob.ai.Team;
import soccorob.ai.Vector;
import soccorob.ai.wm.BallObject;
import soccorob.ai.wm.GoalObject;
import soccorob.ai.wm.PlayerObject;

public class WorldModel {
    public static int players = 3;
    public static final int MAXX = 1250;
    public static final int MAXY = 750;
    private static boolean gameIsRunning = false;
    private static PlayerObject[] we;
    private static PlayerObject[] them;
    private static BallObject ball;
    private static GoalObject ourgoal;
    private static GoalObject theirgoal;

    static {
        ball = new BallObject();
        ourgoal = new GoalObject(new Point(-1250L, 0L), 500);
        theirgoal = new GoalObject(new Point(1250L, 0L), 500);
        we = new PlayerObject[players];
        them = new PlayerObject[players];
        int i = 0;
        while (i < players) {
            WorldModel.we[i] = new PlayerObject(new Point(), new Vector(), Team.WE, i + 1);
            WorldModel.them[i] = new PlayerObject(new Point(), new Vector(), Team.THEM, i + 1);
            ++i;
        }
    }

    private WorldModel() {
    }

    public static PlayerObject getPlayerObject(Team team, int unum) {
        if (unum < 1 || unum > players) {
            Debug.Error("getPlayerObject was called with unknown player");
            return we[0];
        }
        if (team == Team.WE) {
            return we[unum - 1];
        }
        if (team == Team.THEM) {
            return them[unum - 1];
        }
        Debug.Error("getPlayerObject was called with unknown team");
        return we[0];
    }

    public static boolean isGameRunning() {
        return gameIsRunning;
    }

    public static void seePlayer(long time, Team team, int unum, long x, long y, long speed, float angle, int spin, float conf) {
        int nr = unum - 1;
        if (team == Team.WE) {
            WorldModel.we[nr].getPos().x = x;
            WorldModel.we[nr].getPos().y = y;
            we[nr].getVel().setLength(speed);
            we[nr].getVel().setAngle(angle);
            we[nr].setSpin(spin);
            we[nr].setConfidence(conf);
        } else if (team == Team.THEM) {
            WorldModel.them[nr].getPos().x = x;
            WorldModel.them[nr].getPos().y = y;
            them[nr].getVel().setLength(speed);
            them[nr].getVel().setAngle(angle);
            them[nr].setSpin(spin);
            them[nr].setConfidence(conf);
        }
    }

    public static void seeBall(long time, long x, long y, long speed, float angle, float conf) {
        WorldModel.ball.getPos().x = x;
        WorldModel.ball.getPos().y = y;
        ball.getVel().setLength(speed);
        ball.getVel().setAngle(angle);
        ball.setConfidence(conf);
    }

    public static void setGameStatus(boolean shouldPlay) {
        gameIsRunning = shouldPlay;
    }

    public static GoalObject getGoal(Team team) {
        if (team == Team.WE) {
            return ourgoal;
        }
        if (team == Team.THEM) {
            return theirgoal;
        }
        Debug.Error("getGoal for unknown team");
        return ourgoal;
    }

    public static BallObject getBall() {
        return ball;
    }

    public static PlayerObject getClosestTeammate(Point pos) {
        int closest = -1;
        long distance = 1000000L;
        int i = 0;
        while (i < players) {
            if (we[i].getPos().distanceTo(pos) < distance) {
                closest = i;
                distance = we[i].getPos().distanceTo(pos);
            }
            ++i;
        }
        if (closest == -1) {
            Debug.Error("getClosestTeammate didn't find anyone at all.");
        }
        return we[closest];
    }

    public static PlayerObject getClosestTeammate(int unum) {
        int closest = -1;
        long distance = 1000000L;
        int i = 0;
        while (i < players) {
            if (i + 1 != unum && we[i].getPos().distanceTo(WorldModel.getPlayerObject(Team.WE, unum).getPos()) < distance) {
                closest = i;
                distance = we[i].getPos().distanceTo(WorldModel.getPlayerObject(Team.WE, unum).getPos());
            }
            ++i;
        }
        if (closest == -1) {
            Debug.Error("getClosestTeammate didn't find anyone at all.");
        }
        return we[closest];
    }

    public static PlayerObject getClosestOpponent(Point pos) {
        int closest = -1;
        long distance = 1000000L;
        int i = 0;
        while (i < players) {
            if (them[i].getPos().distanceTo(pos) < distance) {
                closest = i;
                distance = them[i].getPos().distanceTo(pos);
            }
            ++i;
        }
        if (closest == -1) {
            Debug.Error("getClosestOpponent didn't find anyone at all.");
        }
        return them[closest];
    }

    public static PlayerObject getClosestPlayer(Point pos) {
        PlayerObject closestTeammate = WorldModel.getClosestTeammate(pos);
        PlayerObject closestOpponent = WorldModel.getClosestOpponent(pos);
        if (closestOpponent.getPos().distanceTo(pos) < closestTeammate.getPos().distanceTo(pos)) {
            return closestOpponent;
        }
        return closestTeammate;
    }

    public void sayTo(int whom, String what) {
    }
}

