/*
 * Decompiled with CFR 0.152.
 */
package soccorob.rt;

import soccorob.rt.ReleaseParameters;
import soccorob.rt.RunnableBlock;
import soccorob.rt.SchedulingParameters;

public class RealtimeThread {
    private SchedulingParameters s;
    private ReleaseParameters rp;
    private String name;
    private int block;
    protected RunnableBlock[] runnableBlocks;
    protected boolean finished;

    public RealtimeThread(SchedulingParameters s, ReleaseParameters rp) {
        this.s = s;
        this.rp = rp;
        this.block = 0;
        this.finished = false;
    }

    public ReleaseParameters getReleaseParameters() {
        return this.rp;
    }

    public SchedulingParameters getSchedulingParameters() {
        return this.s;
    }

    public void setReleaseParameters(ReleaseParameters rp) {
        this.rp = rp;
    }

    public void setSchedulingParameters(SchedulingParameters s) {
        this.s = s;
    }

    public void start() {
        this.run();
    }

    public void run() {
        if (this.block == 0) {
            this.finished = false;
        }
        this.runnableBlocks[this.block].run();
        this.block = (this.block + 1) % this.runnableBlocks.length;
    }

    public RealtimeThread currentRealtimeThread() {
        return this;
    }

    public void waitForNextPeriod() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setReady() {
        this.finished = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

