package soccorob.si.ip;

/**
 * Matrix. Used by the Kalman filter.
 */
public class Matrix {

  public Matrix (int r, int c) {
    data = new double[r][c];
  }

  public void set (int r, int c, double value) { data[r][c] = value; }
  public double get (int r, int c) { return data[r][c]; }

  public void printMatrix () {
    for (int i = 0; i < data.length; i++) {
      for (int j = 0; j < data[0].length; j++) {
	System.out.print(data[i][j] + " ");
      }
      System.out.println();
    }
  }

  public int rows() { return data.length; }
  public int columns() { return data[0].length; }
  
  /**
   * Multiplies a by b and returns in result. <p>
   */
  static public void mult (Matrix a, Matrix b, Matrix result) {

    if (a.columns() != b.rows() ||
	result.rows() != a.rows() ||
	result.columns() != b.columns()) {
      System.err.println("Invalid request on Matix mult");
      return;
    }

    for (int r = 0; r < a.rows(); r++) {
      for (int c = 0; c < b.columns(); c++) {
	result.data[r][c] = 0.0;
	for (int i = 0; i < a.columns(); i++) {
	  result.data[r][c] += a.data[r][i] * b.data[i][c];
	}
      }
    }
  }

  /**
   * Adds a to b and returns in result. <p>
   */
  static public void add (Matrix a, Matrix b, Matrix result) {

    for (int r = 0; r < a.rows(); r++) {
      for (int c = 0; c < a.columns(); c++) {
	result.data[r][c] = a.data[r][c] + b.data[r][c];
      }
    }
  }
  
  /**
   * Minuses b from a and returns in result. <p>
   */
  static public void minus (Matrix a, Matrix b, Matrix result) {

    for (int r = 0; r < a.rows(); r++) {
      for (int c = 0; c < a.columns(); c++) {
	result.data[r][c] = a.data[r][c] - b.data[r][c];
      }
    }
  }
  
  static public void copy(Matrix from, Matrix to) {
    for(int r = 0; r < from.rows() ; r++)
      for(int c = 0; c < from.columns(); c++)
        to.data[r][c] = from.data[r][c];
  }
  
  private double [][] data = null;
}
