#include <windows.h>
#include <iostream.h>
#include "IP.h"
#include "soccorob_si_ip_CameraIP.h"

JNIEXPORT jlong JNICALL Java_soccorob_si_ip_CameraIP_Create
  (JNIEnv *env, jobject obj) {
	
	IP* ptr = new IP(GetDesktopWindow());
	return (jlong)ptr;
}

JNIEXPORT void JNICALL Java_soccorob_si_ip_CameraIP_Destroy
  (JNIEnv *env, jobject obj, jlong objP) {

	IP* ptr = (IP*) objP;
	delete ptr;
}

JNIEXPORT void JNICALL Java_soccorob_si_ip_CameraIP_GetCornerPositions
  (JNIEnv *env, jobject obj, jlong objP, jfloatArray arr) {
	
	IP* ptr = (IP*) objP;
	// Call function to get object positions
	float* ctemp = (ptr->getCornerPositions());
	
	// Get the array from the JVM
	jfloat *body = env->GetFloatArrayElements(arr, 0);
	
	// Copy the new values to the Java array
	int i;
	for (i=0; i<4; i++) {
		body[i] = ctemp[i];
	}
	
	// Update and release the Java array
	env->ReleaseFloatArrayElements(arr, body, 0);
}

JNIEXPORT void JNICALL Java_soccorob_si_ip_CameraIP_GrabFrame
  (JNIEnv *env, jobject obj, jlong objP) {
	
	IP* ptr = (IP*) objP;
	ptr->grabFrame();
}

JNIEXPORT void JNICALL Java_soccorob_si_ip_CameraIP_Convert
  (JNIEnv *env, jobject obj, jlong objP) {

	IP* ptr = (IP*) objP;
	ptr->convert();
}

JNIEXPORT void JNICALL Java_soccorob_si_ip_CameraIP_GetObjectPositions
  (JNIEnv *env, jobject obj, jlong objP, jfloatArray arr) {
	
	IP* ptr = (IP*) objP;
	// Call function to get object positions
	float* ctemp = (ptr->getObjectPositions());
	
	// Get the array from the JVM
	jfloat *body = env->GetFloatArrayElements(arr, 0);
	
	// Copy the new values to the Java array
	int i;
	for (i=0; i<27; i++) {
		body[i] = ctemp[i];
	}
	
	// Update and release the Java array
	env->ReleaseFloatArrayElements(arr, body, 0);
}
